function [sesgo_pond,sesgo_precio,precio_est]=mcnl(beta,x,M,pon);
%
% ESTIMACIN DEL PRECIO DE UN BONO POR EL MTODO 
% NELSON Y SIEGEL Y EL METODO DE SVENSSON.
% "x": hoja de datos.
% M=1:Mtodo Nelson y Siegel
% M=2: Mtodo de Svensson
% pon=0: estimacin sin ponderaciones
% pon=1: estimacion con ponderaciones

[precio,cupon2,plazos]=matrices(x); % FUNCIN

% plazos:matriz de fechas de pagos
% cupon2:matriz de pago de cupn y principal
% preci:vector de precios

if pon==0,
  pond=ones(size(precio,1),1);
elseif pon==1,
  DURA=duratir(x);	         % duracin de cada bono.
  pond=(DURA.^(-1));         % vector de ponderaciones
  pond(1,1)=10000*pond(1,1);
  pond(2,1)=10000*pond(2,1);
  pond(3,1)=10000*pond(3,1);
  pond(4,1)=10000*pond(4,1);
  pond(5,1)=10000*pond(5,1);
end;

p= [];
P=[];
for j=1:size(plazos,1),
   k=1;
   for i=1:size(plazos,2),
     if M==1,
	p(k)=cupon2(j,i)*exp(-beta(1,1)*plazos(j,i)-(beta(2,1)+beta(3,1))*beta(4,1)*(1-exp(-plazos(j,i)/beta(4,1)))+beta(3,1)*plazos(j,i)*exp(-plazos(j,i)/beta(4,1)));
	k=k+1;      
     elseif M==2,
	p(k)=cupon2(j,i)*exp(-beta(1,1)*plazos(j,i)-(beta(2,1)+beta(3,1))*beta(4,1)*(1-exp(-plazos(j,i)/beta(4,1)))+beta(3,1)*plazos(j,i)*exp(-plazos(j,i)/beta(4,1))-beta(5,1)*beta(6,1)*(1-exp(-plazos(j,i)/beta(6,1)))+beta(5,1)*exp(-plazos(j,i)/beta(6,1)));
	k=k+1;
     end;
   end;
P=[P; p];
end;

% precio estimado

size(P)
size(plazos)
k=1;
for i=1:size(plazos,1),
   precio_est(i)=sum(P(i,1:size(P,2)));
end;

% precio_est es un vector fila que contiene el precio 
% estimado para cada uno de los bonos.

% residuos
sesgo_precio=(precio-precio_est');
sesgo_pond=sesgo_precio.*(pond.^(1/2));
