function [P,X,Y]=matrices(x);

% la funcin matrices devuelva a partir de la matriz
% de datos "x" ( que contiene los cupones, los precios
% y los plazos de pago, de cada una de las referencias
% cotizadas en el mercado) un vector "P", y las matrices .
% "X" e "Y".
% P: recoge los precios
% X:matriz que recoge los pagos de cupones y principal
% Y:matriz que recoge las fechas de pago.

c=[x(1:size(x,1),1)]; 		     % vector de cupones

plazos=[x(1:size(x,1),3:size(x,2))]; % matriz de fechas de pago

P=[x(1:size(x,1),2)];	     % vector de precios

%
% A partir de la entrada inicial hemos formado 
% un vector columna referido a los precios de bonos 
% (PRECI), otro vector columna referido a los cupones 
% (C) y una matriz con los plazos de pago de los cupones
% (PLAZOS).
%
%
% Para la estimacin del modelo requerimos dos matrices 
% de semejante tamao que deben contener los plazos de 
% pago  (PLAZOS), Y una matriz donde aparezcan
% los pagos de cupones y principal de todos los bonos.
% En el siguiente apartado  procedemos a construir 
% dicha matriz. (CUPON2).



cup=plazos;

% Creamos una matriz donde aparecen los cupones asociados a cada bono 
% en la fecha de pago correspondiente.En las fechas que no hay pago alguno 
% se definen ceros.

cupon=[];

for i=1:size(plazos,2),

	for j=1:size(plazos,1),

		if cup(j,i)~=-1,
		
		cup(j,i)=c(j,1);
		
		else,

		cup(j,i)=0;
		
		end;
	end;
end;

cupon=[cupon cup];

% con esta instruccin asignamos a las letras 
% el pricipal a los bonos de un nico pago.

for j=1:size(cupon,1),

	if cupon(j,2)==0,

	cupon(j,1)=cupon(j,1)+100;

	else,

	cupon(j,1)=cupon(j,1);


	end;
end;


%  asignamos a todos los bonos el principal siempre que 
% su fecha de vencimiento ne se encuentre en la ltima 
% columna.


cupon1=cupon;

for i=2:(size(cupon,2)-1),

	for j=1:size(cupon,1),

		if cupon(j,i+1)==0,
			
			if cupon(j,i)~=0,

			cupon1(j,i)=cupon(j,i)+100;

			else,

			cupon1(j,i)=cupon(j,i);

			end;
		else,

		cupon1(j,i)=cupon(j,i);

	    end;
    end;
end;
%
% Asignamos el pricipal a aquellos bonos cuyo ltimo 
% pago se est ubicado en la ltima columna.
%

cupon2=cupon1;

i=size(cupon,2);

for j=1:size(cupon,1),

	if cupon(j,i)==0,

	cupon2(j,i)=cupon(j,i);
	
	else,

	cupon2(j,i)=cupon(j,i)+100;

	end;
end;	


%
% La matriz cupon2 contiene los pagos de cupon y 
% principal para cada bono en la fecha correspondiente.
%

X=cupon2;
Y=plazos;