function [F]=forward(plazo, Horizon, betas);
%
% The FORWARD function computes implicit forward rates at a given point in time (horizon)
% for a set of different maturities, defined in vector 'plazo'
%

k=plazo;

for j=1:size(Horizon,1),
	n=Horizon(j,1);
	m=n+k;

	r=tipos(betas,m);
%	R(:,j)=r;  

	rj=tipos(betas,n); 

%	Rj(:,j)=rj; 
	forward=(1/k)*((n+k)*r-n*rj);
		
	F(:,j)=forward;	    
end;


