function [betasr,cuadro,jacobian]=fedet(a,pon,M);
%
% FUNCTION FOR DAILY ESTIMATION OF THE ZERO COUPON CURVE.
%
x=cotiza(a); % cotiza.m eliminate bonds that were not traded 
%
%***************** Duration and IIR **********************
[Dura,Tir]=duratir(x);
%********************************************************

%********************************************************
%pon=input('Weighted least squares?');
if pon=='s'
   pon=1;
else
   pon=0;
end;
%*****************************************************

%**** Initial conditions ****************************

x0=[0.06599352	-0.036538593 -4.14609E-07 2.3961044]';

%************** Estimation Method ******************
%M=input('Estimation method (Nelson =N, Svensson=S)');
if M=='N'
   M=1;
else
   M=2;
end;
%******************************************************

%************** ESTIMATION of beta-vector *****************
% 
% options(14)=5000;	% number of iterations
% options(3)=1e-3;	% convergence in objective function
% options(2)=1e-3;	% convergence in beta-vector
% beta=leastsq('mcnl',x0,options,[],x,M,pon);

options = optimset('MaxIter',5000,'TolFun',1e-3,'TolX',1e-3);
[beta,resnorm,residual,exitflag,output,jacobian]=lsqnonlin('mcnl',x0,[],[],options,x,M,pon);
betasr = [beta; resnorm; exitflag]';

%********** PRICE BIASES ****************************
[sesgo_pond,sesgo_precio,precio_est]=mcnl(beta,x,M,pon);
%******************************************************

%********** TIR BIASES ********************************
[p,x,y]=matrices(x);
[Tir1]=tir(precio_est',x,y);
sesgoTir=Tir-Tir1;
%******************************************************
%*********** RESULTS *********************************
disp('Estimated parameters and residual sum of squares')

cuadro=[Dura Tir sesgo_precio sesgoTir];
%******************************************************

