
% VECTOR DE DURACIONES "DURA" CONTIENE LA DURACIN DE CADA
% REFERENCIA COTIZADA EN EL MERCADO.

% -a- hoja de datos diaria, donde aparecen los datos de precios,
% cupones y plazos de cada bono.

function [DURA,TIR,dif]=dura(a,beta); % a es hoja de datos.

% generamos a partir de la funcin "matrices" el vector de precios "P",
% la matriz de pagos "X", y la matriz de plazos "Y".

[p,x,y]=matrices(a); % funcin

% p=VECTOR DE PRECIOS DE LOS BONOS.
% x=matriz de pagos de cupones y principal.
% y=matriz de plazos.
% RR=matriz que contiene para cada bono (osea en cada fila) 
% los tipos cupn cero que cotiza el mercado a cada una de 
% las fechas pendientes de pago (los tipos estn por columnas)

%beta=[ 0.057	-0.009	-0.031	1.369];


for j=1:size(x,1),

for i=1:size(y,2),
	r=tipos(beta,y(j,i));
	R=[R r];
end;
RR=[RR;R];
R=[];
r=[];
end;

for j=1:size(x,1),

for i=1:size(y,2),

d=((y(j,i)*x(j,i))*exp(-y(j,i)*RR(j,i)))/((p(j,1)));
	D=[D d];

end;
dura=sum(D);

DURA=[DURA;dura];

dura=[];
d=[];
D=[];
end;

