% FICHERO EJECUTABLE PARA LA ESTIMACIN DE LA ETTI
% CON PONDERACIONES IGUAL A LA INVERSA DE LA DURACIN
% 
% Para obtener los tipos forward implcitos hay que
% introducir el vector de horizonte temporal (HORIZON)

load feb22.prn
n=size(feb22,1);
x=feb22(1:n-1,:);

pon='s';
M='N';

horizon=[0.002739726
0.087671233
0.169863014
0.254794521
0.336986301
0.421917808
0.506849315
0.589041096
0.673972603
0.756164384
0.84109589];

%************ESTIMACIN DE LA ETTI ponderada por inversa de duracion************
[betasr cuadro]=fedet(x,pon,M);
% save c:\dat\feb27.prn betasr -ascii;
%*********************************************************

%*****CONVEXIDAD DE LOS BONOS*****************************
betas=[betasr(1,1:4)]
[CONVEX]=convex(x,betas);
disp('     Duration   Convexity   Mkt.price Theoret.price   IRR    price_bias    IRR_bias')
cuadro=[cuadro(:,1) CONVEX x(:,2) x(:,2)+cuadro(:,3) 100*cuadro(:,2) cuadro(:,3:4)]
% save c:\dat\cene37.prn cuadro -ascii;
%*********************************************************

%***********EXPECTATIVAS DE TIPOS*************************
plazos=[1/365 1/12 3/12 6/12 1 3 5 10 15]';
F1=[];
for i=1:size(plazos,1)
   plazo=plazos(i,1);
   f1=forward(plazo, horizon, betas);
   F1=[F1;f1];
end

%  The output is a matrix with as many rows as 'plazos' and as many columns
%  as 'horizons'. To get the 1-day forward rate at each of the 'horizons',
%  look at row 1. To get the forward rate one day from now at the different
%  'plazos' look at the first column.

Etipos=F1';
disp('Interest rate Expectations = Forward rates')
disp('at 1 day horizon and successive months: 1 day from now, 1 month, 2 months from now,...')
disp('each row correspondes to an investment period, in years, as in first column')
[plazos 100*F1]
%  save c:\dat\Etipos.prn Etipos -ascii;

figure
plot(cuadro(:,1),cuadro(:,5),'b*');
matur = [1/365:.25:35];
[zerocpn] = tipos(betas,matur');
figure
plot(zerocpn);
figure
plot(F1);
figure
plot(F1');
%hold off;