function varargout = SDT_SP1(varargin)


%%%Dr. Ignacio Serrano-Pedraza 2018
%%%iserrano@ucm.es

% SDT_SP1 MATLAB code for SDT_SP1.fig
%      SDT_SP1, by itself, creates a new SDT_SP1 or raises the existing
%      singleton*.
%
%      H = SDT_SP1 returns the handle to a new SDT_SP1 or the handle to
%      the existing singleton*.
%
%      SDT_SP1('CALLBACK',hObject,eventData,handles,...) calls the local
%      function named CALLBACK in SDT_SP1.M with the given input arguments.
%
%      SDT_SP1('Property','Value',...) creates a new SDT_SP1 or raises the
%      existing singleton*.  Starting from the left, property value pairs are
%      applied to the GUI before SDT_SP1_OpeningFcn gets called.  An
%      unrecognized property name or invalid value makes property application
%      stop.  All inputs are passed to SDT_SP1_OpeningFcn via varargin.
%
%      *See GUI Options on GUIDE's Tools menu.  Choose "GUI allows only one
%      instance to run (singleton)".
%
% See also: GUIDE, GUIDATA, GUIHANDLES

% Edit the above text to modify the response to help SDT_SP1

% Last Modified by GUIDE v2.5 15-Mar-2018 15:45:37

% Begin initialization code - DO NOT EDIT
gui_Singleton = 1;
gui_State = struct('gui_Name',       mfilename, ...
                   'gui_Singleton',  gui_Singleton, ...
                   'gui_OpeningFcn', @SDT_SP1_OpeningFcn, ...
                   'gui_OutputFcn',  @SDT_SP1_OutputFcn, ...
                   'gui_LayoutFcn',  [] , ...
                   'gui_Callback',   []);
if nargin && ischar(varargin{1})
    gui_State.gui_Callback = str2func(varargin{1});
end

if nargout
    [varargout{1:nargout}] = gui_mainfcn(gui_State, varargin{:});
else
    gui_mainfcn(gui_State, varargin{:});
end
% End initialization code - DO NOT EDIT

% --- Executes just before SDT_SP1 is made visible.
function SDT_SP1_OpeningFcn(hObject, eventdata, handles, varargin)
% This function has no output args, see OutputFcn.
% hObject    handle to figure
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)
% varargin   command line arguments to SDT_SP1 (see VARARGIN)

% Choose default command line output for SDT_SP1
handles.output = hObject;
    set(hObject,'WindowButtonDownFcn',  @mouseDown);
    set(hObject,'WindowButtonMotionFcn',@mouseMove);
    set(hObject,'WindowButtonUpFcn',    @mouseUp);
  
% Play_sound handles structure
guidata(hObject, handles);

Plot_figure(hObject, eventdata, handles)


function Plot_figure(hObject, eventdata, handles)
expt = getexpt(handles);


SigmaSA=expt.sigmaS1;
SigmaNA=expt.sigmaN1;

SigmaSB=expt.sigmaS2;
SigmaNB=expt.sigmaN2;

if expt.activate_beta1==0 && expt.activate_dA==0 && expt.Probabilidades1==0 && expt.RocA==0
set(handles.Results1,'Value',1)
expt.Results1  = get(handles.Results1,'value');
set(handles.Aciertos1,'BackgroundColor',[0.729 0.831 0.957])
set(handles.Errores1,'BackgroundColor',[0.729 0.831 0.957])
set(handles.Falsas_alarmas1,'BackgroundColor',[0.729 0.831 0.957])
set(handles.Rechazos_correctos1,'BackgroundColor',[0.729 0.831 0.957])

end
if expt.activate_beta2==0 && expt.activate_dB==0 && expt.Probabilidades2==0 && expt.RocB==0
set(handles.Results2,'Value',1)
expt.Results2  = get(handles.Results2,'value');
set(handles.Aciertos2,'BackgroundColor',[0.925 0.839 0.839])
set(handles.Errores2,'BackgroundColor',[0.925 0.839 0.839])
set(handles.Falsas_alarmas2,'BackgroundColor',[0.925 0.839 0.839])
set(handles.Rechazos_correctos2,'BackgroundColor',[0.925 0.839 0.839])

end
if expt.Results1==1
totalsnA=expt.Aciertos1+expt.Errores1;
totalnA=expt.Falsas_alarmas1+expt.Rechazos_correctos1;

set(handles.TotalsnA, 'String', totalsnA);
set(handles.TotalnA, 'String', totalnA);
set(handles.TotalA, 'String', totalsnA+totalnA);

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
probAC1=expt.Aciertos1/totalsnA;
probFA1=expt.Falsas_alarmas1/totalnA;
probER1=1-probAC1;
probRC1=1-probFA1;
set(handles.Prob_AC1, 'String', num2str(probAC1,'%10.3f'));
set(handles.Prob_ER1, 'String', num2str(probER1,'%10.3f'));
set(handles.Prob_FA1, 'String', num2str(probFA1,'%10.3f'));
set(handles.Prob_RC1, 'String', num2str(probRC1,'%10.3f'));
set(handles.probabilidadesAC1, 'String',  num2str(probAC1,'%10.3f'));
set(handles.probabilidadesFA1, 'String', num2str(probFA1,'%10.3f'));

zAC1=norminv(1-probAC1,0,SigmaSA);
zFA1=norminv(1-probFA1,0,SigmaNA);
set(handles.zFA1, 'String',num2str(zFA1,'%10.3f'));
set(handles.zAC1, 'String',num2str(zAC1,'%10.3f'));

dA=zFA1-(SigmaSA/SigmaNA)*zAC1; 

set(handles.dA, 'String', num2str(dA,'%10.3f'));

betaA=(SigmaNA/SigmaSA)*exp((zFA1^2-zAC1^2)/2);
set(handles.betaA, 'String', num2str(betaA,'%10.3f'));

CA=(zFA1+zAC1)/2;
set(handles.CA, 'String', num2str(CA,'%10.3f'));
end
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
if expt.activate_beta1==1 || expt.activate_dA==1
dA=expt.dA;
zFA1=expt.zFA1;
zAC1=(SigmaNA/SigmaSA)*(zFA1-dA);
betaA=expt.betaA;

CA=expt.CA;
if expt.activate_beta1==0  && (SigmaSA==SigmaNA)

zAC1=(2*log(expt.betaA)-dA^2)/(2*dA);%%This is a problem when sigmaA is > sigmaB This equation doesn't work.
zFA1=(2*log(expt.betaA)+dA^2)/(2*dA);
CA=(zFA1+zAC1)/2;
set(handles.CA, 'String', num2str(CA,'%10.3f'));
end

if expt.activate_beta1==0  && (SigmaSA~=SigmaNA)

    %zFA1=(2*CA+dA)/2;
    %zAC1=(2*CA-dA)/2;

 r=(SigmaNA/SigmaSA);
 zFA1=(2*CA+dA*r)./(1+r);
 zAC1=(2*CA-dA)./(1+(SigmaSA/SigmaNA));
    
end
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%if expt.activate_beta1==1
probAC1=1-normcdf(zAC1,0,SigmaSA);
probFA1=1-normcdf(zFA1,0,SigmaNA);

probER1=1-probAC1;
probRC1=1-probFA1;
set(handles.Prob_AC1, 'String', num2str(probAC1,'%10.3f'));
set(handles.Prob_ER1, 'String', num2str(probER1,'%10.3f'));
set(handles.Prob_FA1, 'String', num2str(probFA1,'%10.3f'));
set(handles.Prob_RC1, 'String', num2str(probRC1,'%10.3f'));
set(handles.probabilidadesAC1, 'String',  num2str(probAC1,'%10.3f'));
set(handles.probabilidadesFA1, 'String', num2str(probFA1,'%10.3f'));
totalsnA=expt.TotalsnA;
totalnA=expt.TotalnA;

set(handles.TotalA, 'String', round(totalsnA+totalnA));

set(handles.Aciertos1, 'String', round(totalsnA*expt.Prob_AC1));
set(handles.Falsas_alarmas1, 'String', round(totalnA*expt.Prob_FA1));
set(handles.Errores1, 'String', totalsnA-round(totalsnA*expt.Prob_AC1));
set(handles.Rechazos_correctos1, 'String', totalnA-round(totalnA*expt.Prob_FA1));


set(handles.zAC1, 'String',num2str(zAC1,'%10.3f'));
set(handles.zFA1, 'String',num2str(zFA1,'%10.3f'));

if expt.activate_beta1==1 && (SigmaSA ~= SigmaNA)
betaA=(SigmaNA/SigmaSA)*exp((zFA1^2-zAC1^2)/2);
set(handles.betaA, 'String', num2str(betaA,'%10.3f'));
end
if expt.activate_beta1==1 && (SigmaSA ~= SigmaNA)
    CA=(zFA1+zAC1)/2;
set(handles.CA, 'String', num2str(CA,'%10.3f'));
end

if expt.activate_beta1==0 && (SigmaSA ~= SigmaNA)
betaA=(SigmaNA/SigmaSA)*exp((zFA1^2-zAC1^2)/2);
set(handles.betaA, 'String', num2str(betaA,'%10.3f'));

CA=(zFA1+zAC1)/2;
set(handles.CA, 'String', num2str(CA,'%10.3f'));
end

if expt.activate_beta1==1 && (SigmaSA == SigmaNA)
    betaA=(SigmaNA/SigmaSA)*exp((zFA1^2-zAC1^2)/2);
set(handles.betaA, 'String', num2str(betaA,'%10.3f'));
CA=(zFA1+zAC1)/2;
set(handles.CA, 'String', num2str(CA,'%10.3f'));
end
end
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

if expt.RocA==1
totalsnA=expt.TotalsnA;
totalnA=expt.TotalnA;

set(handles.TotalA, 'String', round(totalsnA+totalnA));

set(handles.Aciertos1, 'String', round(totalsnA*expt.Prob_AC1));
set(handles.Falsas_alarmas1, 'String', round(totalnA*expt.Prob_FA1));
set(handles.Errores1, 'String', totalsnA-round(totalsnA*expt.Prob_AC1));
set(handles.Rechazos_correctos1, 'String', totalnA-round(totalnA*expt.Prob_FA1));


%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
probAC1=expt.Prob_AC1;
probFA1=expt.Prob_FA1;
probER1=1-probAC1;
probRC1=1-probFA1;
set(handles.Prob_ER1, 'String', num2str(1-expt.Prob_AC1,'%10.3f'));
set(handles.Prob_RC1, 'String', num2str(1-expt.Prob_FA1,'%10.3f'));
set(handles.probabilidadesAC1, 'String',  num2str(probAC1,'%10.3f'));
set(handles.probabilidadesFA1, 'String', num2str(probFA1,'%10.3f'));

zAC1=norminv(1-probAC1,0,SigmaSA);
if expt.activate_beta1==0
zFA1=norminv(1-probFA1,0,SigmaNA);
set(handles.zFA1, 'String',num2str(zFA1,'%10.3f'));
else
zFA1=expt.zFA1;
end
set(handles.zAC1, 'String',num2str(zAC1,'%10.3f'));

dA=zFA1-(SigmaSA/SigmaNA)*zAC1;
set(handles.dA, 'String', num2str(dA,'%10.3f'));

betaA=(SigmaNA/SigmaSA)*exp((zFA1^2-zAC1^2)/2);
set(handles.betaA, 'String', num2str(betaA,'%10.3f'));

CA=(zFA1+zAC1)/2;
set(handles.CA, 'String', num2str(CA,'%10.3f'));
end

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

if expt.Probabilidades1==1
totalsnA=expt.TotalsnA;
totalnA=expt.TotalnA;

set(handles.TotalA, 'String', round(totalsnA+totalnA));

set(handles.Aciertos1, 'String', round(totalsnA*expt.Prob_AC1));
set(handles.Falsas_alarmas1, 'String', round(totalnA*expt.Prob_FA1));
set(handles.Errores1, 'String', totalsnA-round(totalsnA*expt.Prob_AC1));
set(handles.Rechazos_correctos1, 'String', totalnA-round(totalnA*expt.Prob_FA1));


%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
probAC1=expt.Prob_AC1;
probFA1=expt.Prob_FA1;
probER1=1-probAC1;
probRC1=1-probFA1;
set(handles.Prob_ER1, 'String', num2str(1-expt.Prob_AC1,'%10.3f'));
set(handles.Prob_RC1, 'String', num2str(1-expt.Prob_FA1,'%10.3f'));
set(handles.probabilidadesAC1, 'String',  num2str(probAC1,'%10.3f'));
set(handles.probabilidadesFA1, 'String', num2str(probFA1,'%10.3f'));

zAC1=norminv(1-probAC1,0,SigmaSA);
if expt.activate_beta1==0
zFA1=norminv(1-probFA1,0,SigmaNA);
set(handles.zFA1, 'String',num2str(zFA1,'%10.3f'));
else
zFA1=expt.zFA1;
end
set(handles.zAC1, 'String',num2str(zAC1,'%10.3f'));

dA=zFA1-(SigmaSA/SigmaNA)*zAC1;
set(handles.dA, 'String', num2str(dA,'%10.3f'));

betaA=(SigmaNA/SigmaSA)*exp((zFA1^2-zAC1^2)/2);


set(handles.betaA, 'String', num2str(betaA,'%10.3f'));

CA=(zFA1+zAC1)/2;
set(handles.CA, 'String', num2str(CA,'%10.3f'));
end

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

if expt.Results2==1
totalsnB=expt.Aciertos2+expt.Errores2;
totalnB=expt.Falsas_alarmas2+expt.Rechazos_correctos2;

set(handles.TotalsnB, 'String', totalsnB);
set(handles.TotalnB, 'String', totalnB);
set(handles.TotalB, 'String', totalsnB+totalnB);

probAC2=expt.Aciertos2/totalsnB;
probFA2=expt.Falsas_alarmas2/totalnB;
probER2=1-probAC2;
probRC2=1-probFA2;
set(handles.Prob_AC2, 'String', num2str(probAC2,'%10.3f'));
set(handles.Prob_ER2, 'String', num2str(probER2,'%10.3f'));
set(handles.Prob_FA2, 'String', num2str(probFA2,'%10.3f'));
set(handles.Prob_RC2, 'String', num2str(probRC2,'%10.3f'));
set(handles.probabilidadesAC2, 'String', num2str(probAC2,'%10.3f'));
set(handles.probabilidadesFA2, 'String', num2str(probFA2,'%10.3f'));

zAC2=norminv(1-probAC2,0,SigmaSB);
zFA2=norminv(1-probFA2,0,SigmaNB);

set(handles.zAC2, 'String',num2str(zAC2,'%10.3f'));
set(handles.zFA2, 'String',num2str(zFA2,'%10.3f'));
dB=zFA2-(SigmaSB/SigmaNB)*zAC2;
set(handles.dB, 'String', num2str(dB,'%10.3f'));

%betaB=exp((zFA2^2-zAC2^2)/2);
betaB=(SigmaNB/SigmaSB)*exp((zFA2^2-zAC2^2)/2);

set(handles.betaB, 'String', num2str(betaB,'%10.3f'));

CB=(zFA2+zAC2)/2;
set(handles.CB, 'String', num2str(CB,'%10.3f'));
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
end

if expt.Probabilidades2==1
totalsnB=expt.TotalsnB;
totalnB=expt.TotalnB;

set(handles.TotalB, 'String', round(totalsnB+totalnB));

set(handles.Aciertos2, 'String', round(totalsnB*expt.Prob_AC2));
set(handles.Falsas_alarmas2, 'String', round(totalnB*expt.Prob_FA2));
set(handles.Errores2, 'String', totalsnB-round(totalsnB*expt.Prob_AC2));
set(handles.Rechazos_correctos2, 'String', totalnB-round(totalnB*expt.Prob_FA2));


%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
probAC2=expt.Prob_AC2;
probFA2=expt.Prob_FA2;
probER2=1-probAC2;
probRC2=1-probFA2;
set(handles.Prob_ER2, 'String', num2str(1-expt.Prob_AC2,'%10.3f'));
set(handles.Prob_RC2, 'String', num2str(1-expt.Prob_FA2,'%10.3f'));
set(handles.probabilidadesAC2, 'String',  num2str(probAC2,'%10.3f'));
set(handles.probabilidadesFA2, 'String', num2str(probFA2,'%10.3f'));

zAC2=norminv(1-probAC2,0,SigmaSB);
zFA2=norminv(1-probFA2,0,SigmaNB);

set(handles.zAC2, 'String',num2str(zAC2,'%10.3f'));
set(handles.zFA2, 'String',num2str(zFA2,'%10.3f'));

dB=zFA2-(SigmaSB/SigmaNB)*zAC2;
set(handles.dB, 'String', num2str(dB,'%10.3f'));

%%%betaB=exp((zFA2^2-zAC2^2)/2);
betaB=(SigmaNB/SigmaSB)*exp((zFA2^2-zAC2^2)/2);

set(handles.betaB, 'String', num2str(betaB,'%10.3f'));

CB=(zFA2+zAC2)/2;
set(handles.CB, 'String', num2str(CB,'%10.3f'));
end


%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

if expt.RocB==1
totalsnB=expt.TotalsnB;
totalnB=expt.TotalnB;

set(handles.TotalB, 'String', round(totalsnA+totalnB));

set(handles.Aciertos2, 'String', round(totalsnB*expt.Prob_AC2));
set(handles.Falsas_alarmas2, 'String', round(totalnB*expt.Prob_FA2));
set(handles.Errores2, 'String', totalsnB-round(totalsnB*expt.Prob_AC2));
set(handles.Rechazos_correctos2, 'String', totalnB-round(totalnB*expt.Prob_FA2));


%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
probAC2=expt.Prob_AC2;
probFA2=expt.Prob_FA2;
probER2=1-probAC2;
probRC2=1-probFA2;
set(handles.Prob_ER2, 'String', num2str(1-expt.Prob_AC2,'%10.3f'));
set(handles.Prob_RC2, 'String', num2str(1-expt.Prob_FA2,'%10.3f'));
set(handles.probabilidadesAC2, 'String',  num2str(probAC2,'%10.3f'));
set(handles.probabilidadesFA2, 'String', num2str(probFA2,'%10.3f'));

zAC2=norminv(1-probAC2,0,SigmaSB);
if expt.activate_beta2==0
zFA2=norminv(1-probFA2,0,SigmaNB);
set(handles.zFA2, 'String',num2str(zFA2,'%10.3f'));
else
zFA2=expt.zFA2;
set(handles.zFA2, 'String',num2str(zFA2,'%10.3f'));

end
set(handles.zAC2, 'String',num2str(zAC2,'%10.3f'));

dB=zFA2-(SigmaSB/SigmaNB)*zAC2;
set(handles.dB, 'String', num2str(dB,'%10.3f'));

betaB=(SigmaNB/SigmaSB)*exp((zFA2^2-zAC2^2)/2);
set(handles.betaB, 'String', num2str(betaB,'%10.3f'));

CB=(zFA2+zAC2)/2;
set(handles.CB, 'String', num2str(CB,'%10.3f'));
end

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
if expt.activate_beta2==1 || expt.activate_dB==1
dB=expt.dB;
zFA2=expt.zFA2;
zAC2=(SigmaNB/SigmaSB)*(zFA2-dB);
betaB=expt.betaB;

CB=expt.CB;
if expt.activate_beta2==0  && (SigmaSB==SigmaNB)

zAC2=(2*log(expt.betaB)-dB^2)/(2*dB);%%This is a problem when sigmaA is > sigmaB This equation doesn't work.
zFA2=(2*log(expt.betaB)+dB^2)/(2*dB);
CB=(zFA2+zAC2)/2;
set(handles.CB, 'String', num2str(CB,'%10.3f'));
end

if expt.activate_beta2==0  && (SigmaSB~=SigmaNB)


 r=(SigmaNB/SigmaSB);
 zFA2=(2*CB+dB*r)./(1+r);
 zAC2=(2*CB-dB)./(1+(SigmaSB/SigmaNB));
    
end
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%if expt.activate_beta1==1
probAC2=1-normcdf(zAC2,0,SigmaSB);
probFA2=1-normcdf(zFA2,0,SigmaNB);

probER2=1-probAC2;
probRC2=1-probFA2;
set(handles.Prob_AC2, 'String', num2str(probAC2,'%10.3f'));
set(handles.Prob_ER2, 'String', num2str(probER2,'%10.3f'));
set(handles.Prob_FA2, 'String', num2str(probFA2,'%10.3f'));
set(handles.Prob_RC2, 'String', num2str(probRC2,'%10.3f'));
set(handles.probabilidadesAC2, 'String',  num2str(probAC2,'%10.3f'));
set(handles.probabilidadesFA2, 'String', num2str(probFA2,'%10.3f'));
totalsnB=expt.TotalsnB;
totalnB=expt.TotalnB;

set(handles.TotalB, 'String', round(totalsnB+totalnB));

set(handles.Aciertos2, 'String', round(totalsnB*expt.Prob_AC2));
set(handles.Falsas_alarmas2, 'String', round(totalnB*expt.Prob_FA2));
set(handles.Errores2, 'String', totalsnB-round(totalsnB*expt.Prob_AC2));
set(handles.Rechazos_correctos2, 'String', totalnB-round(totalnB*expt.Prob_FA2));


set(handles.zAC2, 'String',num2str(zAC2,'%10.3f'));
set(handles.zFA2, 'String',num2str(zFA2,'%10.3f'));

if expt.activate_beta2==1 && (SigmaSB ~= SigmaNB)
betaB=(SigmaNB/SigmaSB)*exp((zFA2^2-zAC2^2)/2);
set(handles.betaB, 'String', num2str(betaB,'%10.3f'));
end
if expt.activate_beta2==1 && (SigmaSB ~= SigmaNB)
    CB=(zFA2+zAC2)/2;
set(handles.CB, 'String', num2str(CB,'%10.3f'));
end

if expt.activate_beta2==0 && (SigmaSB ~= SigmaNB)
betaB=(SigmaNB/SigmaSB)*exp((zFA2^2-zAC2^2)/2);
set(handles.betaB, 'String', num2str(betaB,'%10.3f'));

CB=(zFA2+zAC2)/2;
set(handles.CB, 'String', num2str(CB,'%10.3f'));
end

if expt.activate_beta2==1 && (SigmaSB == SigmaNB)
betaB=(SigmaNB/SigmaSB)*exp((zFA2^2-zAC2^2)/2);
set(handles.betaB, 'String', num2str(betaB,'%10.3f'));
CB=(zFA2+zAC2)/2;
set(handles.CB, 'String', num2str(CB,'%10.3f'));
end
end
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%




X=[-6:0.01:6];
normal_noise=normpdf(X,0,SigmaNA);
CDF_noiseA=1-normcdf(X,0,SigmaNA);
for i=1:length(dA)
normal_signalnoise(i,:)=normpdf(X-dA(i),0,SigmaSA);
CDF_signalnoiseA(i,:)=1-normcdf((SigmaNA/SigmaSA)*(X-dA(i)),0,SigmaSA);
end
axes(handles.Plot1)
cla
%handles.output = hObject
%get(handles.Plot1,'figure')
    %hfig=handles.Plot1

plot(X,normal_noise,'b-',X,normal_signalnoise,'g-')
% legend('n','s+n')
% lgd.Location = 'northEast'
% lgd.FontSize = 11
% lgd.Box = 'off'

A = get(handles.zFA1,'string');
zFA1 = str2double(A);
%A = get(handles.zFA2,'string');
%zFA2 = str2double(A);
%hVerticalLines = line([zFA1,zFA1],get(handles.Plot1,'Ylim'),'Color','red');
% hLineToDrag = [];
 
hold on
plot([zFA1 zFA1],[0 0.5],'k--')
 axis([-6 6 0 0.5])
 xlabel('x (in z units)')
 ylabel('Probability density')
 th_text=['d'' = ',num2str(dA)];
 text(-5,0.34, th_text, 'Color', 'b', 'FontSize',20/1.3)
 th_text=['beta = ',num2str(betaA)];
 text(-5,0.28, th_text, 'Color', 'b', 'FontSize',20/1.3)
 th_text=['C = ',num2str(CA)];
 text(-5,0.22, th_text, 'Color', 'b', 'FontSize',20/1.3)

 
 th_text=['Subject A'];
 text(-5.4,0.43, th_text, 'Color', 'b', 'FontSize',20/1.3,'FontWeight','bold')
       
 


normal_noise=normpdf(X,0,SigmaNB);
CDF_noiseB=1-normcdf(X,0,SigmaNB);
for i=1:length(dB)
normal_signalnoise(i,:)=normpdf(X-dB(i),0,SigmaSB);
CDF_signalnoiseB(i,:)=1-normcdf((SigmaNB/SigmaSB)*(X-dB(i)),0,SigmaSB);
end
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
axes(handles.Plot2);
cla;
plot(X,normal_noise,'b-',X,normal_signalnoise,'g-')
% lgd=legend('n','s+n')
% lgd.Location = 'northEast'
% lgd.FontSize = 11
% lgd.Box = 'off'

hold on
plot([zFA2 zFA2],[0 0.5],'k--')
 axis([-6 6 0 0.5])
 xlabel('x (in z units)')
 ylabel('Probability density')
   th_text=['d'' = ',num2str(dB)];
 text(-5,0.34, th_text, 'Color', 'r', 'FontSize',20/1.3)
   th_text=['beta = ',num2str(betaB)];
 text(-5,0.28, th_text, 'Color', 'r', 'FontSize',20/1.3)
  th_text=['C = ',num2str(CB)];
 text(-5,0.22, th_text, 'Color', 'r', 'FontSize',20/1.3)

 th_text=['Subject B'];
 text(-5.4,0.43, th_text, 'Color', 'r', 'FontSize',20/1.3,'FontWeight','bold')
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
axes(handles.Plot3);
cla;
if expt.Subject1==1
plot(CDF_noiseA,CDF_signalnoiseA,'b-')
hold on
end
if expt.Subject2==1
plot(CDF_noiseB,CDF_signalnoiseB,'r-')
hold on
end
if expt.resultados_botonA==1
    hold on
    plot(probFA1,probAC1,'bo')
end
if expt.resultados_botonB==1
    hold on
    plot(probFA2,probAC2,'ro')
end

if expt.isobiasbeta1==1 & (SigmaSA==SigmaNA)
d=[0.01:0.01:8];

if SigmaSA==SigmaNA
zs=(2*log(betaA)-d.^2)./(2*d);
zn=(2*log(betaA)+d.^2)./(2*d);
else
    d=[0.01:0.01:8];

    
r=SigmaNA/SigmaSA;
A = get(handles.zFA1,'string');
zFA1 = str2double(A);
%zn=(-((2*r^2)*d)+sqrt((2*r^2*d).^2-4*(1-r^2)*(2*log(r)-r^2*d.^2-2*log(betaA))))./(2*(1-r^2));%%VSV 2017. Calculus of Zn & Zs+n for unequal variances
%else
%zn=abs(-((2*r^2)*d)-sqrt((2*r^2*d).^2-4*(1-r^2)*(2*log(r)-r^2*d.^2-2*log(betaA))))./(2*(1-r^2));
%end   
%zs=r*(zn-d);


zAC1=sqrt(zFA1^2-2*log(beta*SigmaSA/SigmaNA)); 
% 
% r=(SigmaNA/SigmaSA);
% zn=(2*CA+d*r)./(1+r);%%%ISP 2017. Calculus of Zn & Zs+n for unequal variances
% zs=(2*CA-d)./(1+(SigmaSA/SigmaNA));

 end
prob_AC=1-normcdf(zs,0,SigmaSA);
prob_FA=1-normcdf(zn,0,SigmaNA);
plot(prob_FA,prob_AC,'b-')
end
if expt.isobiasbeta2==1 & (SigmaSB==SigmaNB)
d=[0.01:0.01:8];
zs=(2*log(betaB)-d.^2)./(2*d);
zn=(2*log(betaB)+d.^2)./(2*d);
prob_AC=1-normcdf(zs,0,SigmaSB);
prob_FA=1-normcdf(zn,0,SigmaNB);
plot(prob_FA,prob_AC,'r-')
end      
if expt.isobiasC1==1
d=[0.01:0.01:8];
%zn=(2*CA+d)/2;
%zs=(2*CA-d)/2;
r=(SigmaNA/SigmaSA);
zn=(2*CA+d*r)./(1+r);%%%ISP 2017. Calculus of Zn & Zs+n for unequal variances
zs=(2*CA-d)./(1+(SigmaSA/SigmaNA));


prob_AC=1-normcdf(zs,0,SigmaSA);
prob_FA=1-normcdf(zn,0,SigmaNA);
plot(prob_FA,prob_AC,'b-')

end
if expt.isobiasC2==1
d=[0.01:0.01:8];
% zn=(2*CB(i)+d)/2;
% zs=(2*CB(i)-d)/2;
r=(SigmaNB/SigmaSB);
zn=(2*CB+d*r)./(1+r);%%%ISP 2017. Calculus of Zn & Zs+n for unequal variances
zs=(2*CB-d)./(1+(SigmaSB/SigmaNB));

prob_AC=1-normcdf(zs,0,SigmaSB);
prob_FA=1-normcdf(zn,0,SigmaNB);
plot(prob_FA,prob_AC,'r-')

end

hold on
plot([0 1],[0 1],'k--')



title('ROC Plot')

axis([0 1 0 1])
grid on
axis square
 xlabel('P(Y|n)')
 ylabel('P(Y|s+n)')

 

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
axes(handles.Plot4);
cla;

datos_A_1=norminv(CDF_noiseA,0,SigmaNA);
datos_B_1=norminv(CDF_signalnoiseA,0,SigmaSA);

H=find(datos_A_1>=3 | datos_A_1<=-3.1 |  datos_B_1>=3 | datos_B_1<=-3.1 );
datos_A_1(H)=[];
datos_B_1(H)=[];

plot([-3 3],[-3 3],'k--',[-3 0],[3 0],'k--',[-3 3],[0 0],'k--',[0 0],[-3 3],'k--')
hold on

if (SigmaSA~=SigmaNA)
set(handles.isobiasbeta1,'visible','off');
else
set(handles.isobiasbeta1,'visible','on');
end

if (SigmaSB~=SigmaNB)
set(handles.isobiasbeta2,'visible','off');
else
set(handles.isobiasbeta2,'visible','on');
end

if expt.isobiasbeta1==1  & (SigmaSA==SigmaNA)
if (SigmaSA==SigmaNA)
d=[0.01:0.01:8];
zs=(2*log(betaA)-d.^2)./(2*d);
zn=(2*log(betaA)+d.^2)./(2*d);
prob_AC=1-normcdf(zs,0,SigmaSA);
prob_FA=1-normcdf(zn,0,SigmaNA);
datos_A_11=norminv(prob_FA,0,1);
datos_B_11=norminv(prob_AC,0,1);
plot(datos_A_11,datos_B_11,'b-')
hold on
else
d=[0.01:0.01:8];
r=SigmaNA/SigmaSA;

zn=(-((2*r^2)*d)+sqrt((2*r^2*d).^2-4*(1-r^2)*(2*log(r)-r^2*d.^2-2*log(betaA))))./(2*(1-r^2));
zs=r*(zn-d);

prob_AC=1-normcdf(zs,0,SigmaSA);
prob_FA=1-normcdf(zn,0,SigmaNA);
datos_A_11=norminv(prob_FA,0,SigmaNA);
datos_B_11=norminv(prob_AC,0,SigmaSA);
plot(datos_A_11,datos_B_11,'b-')
hold on 
end
    end
if expt.isobiasC1==1
d=[0.01:0.01:8];
%zn=(2*CA(i)+d)/2;
%zs=(2*CA(i)-d)/2;
r=(SigmaNA/SigmaSA);
zn=(2*CA+d*r)./(1+r);%%%ISP 2017. Calculus of Zn & Zs+n for unequal variances
zs=(2*CA-d)./(1+(SigmaSA/SigmaNA));

prob_AC=1-normcdf(zs,0,SigmaSA);
prob_FA=1-normcdf(zn,0,SigmaNA);
datos_A_11=norminv(prob_FA,0,SigmaNA);
datos_B_11=norminv(prob_AC,0,SigmaSA);
plot(datos_A_11,datos_B_11,'b-')
hold on
end
if expt.Subject1==1
plot(datos_A_1,datos_B_1,'b-')
hold on
%if (expt.sigmaS1>=expt.sigmaN1 & expt.sigmaN1>=1) |  (expt.sigmaS1<=expt.sigmaN1 & expt.sigmaS1<1)
if (expt.sigmaS1>=expt.sigmaN1) |  (expt.sigmaS1<=expt.sigmaN1)
plot([-dA -dA],[-3 0],'b--')
else
plot([-3 0],[dA dA],'b--')
end   
end
if expt.resultados_botonA==1
plot(norminv(probFA1,0,SigmaNA),norminv(probAC1,0,SigmaSA),'bo')
end



datos_A_1=norminv(CDF_noiseB,0,SigmaNB);
datos_B_1=norminv(CDF_signalnoiseB,0,SigmaSB);

H=find(datos_A_1>=3 | datos_A_1<=-3.1 |  datos_B_1>=3 | datos_B_1<=-3.1 );
datos_A_1(H)=[];
datos_B_1(H)=[];
if expt.isobiasbeta2==1  & (SigmaSB==SigmaNB)
d=[0.01:0.01:8];
zs=(2*log(betaB)-d.^2)./(2*d);
zn=(2*log(betaB)+d.^2)./(2*d);
prob_AC=1-normcdf(zs,0,SigmaSB);
prob_FA=1-normcdf(zn,0,SigmaNB);
datos_A_11=norminv(prob_FA,0,1);
datos_B_11=norminv(prob_AC,0,1);
plot(datos_A_11,datos_B_11,'r-')
hold on
    end
if expt.isobiasC2==1
d=[0.01:0.01:8];
%zn=(2*CB(i)+d)/2;
%zs=(2*CB(i)-d)/2;
r=(SigmaNB/SigmaSB);
zn=(2*CB+d*r)./(1+r);%%%ISP 2017. Calculus of Zn & Zs+n for unequal variances
zs=(2*CB-d)./(1+(SigmaSB/SigmaNB));

prob_AC=1-normcdf(zs,0,SigmaSB);
prob_FA=1-normcdf(zn,0,SigmaNB);
datos_A_11=norminv(prob_FA,0,SigmaNB);
datos_B_11=norminv(prob_AC,0,SigmaSB);
plot(datos_A_11,datos_B_11,'r-')
hold on
end

if expt.Subject2==1
plot(datos_A_1,datos_B_1,'r-')
hold on
if (expt.sigmaS2>=expt.sigmaN2 & expt.sigmaN2>=1) |  (expt.sigmaS2<=expt.sigmaN2 & expt.sigmaS2<1)
plot([-dB -dB],[-3 0],'r--')
else
plot([-3 0],[dB dB],'r--')
end   
end
if expt.resultados_botonB==1
plot(norminv(probFA2,0,SigmaNB),norminv(probAC2,0,SigmaSB),'ro')
end


set(gca,'XTick',-3:1:3)
set(gca,'XTickLabel',{'3','2','1','0','-1','-2','-3'})
set(gca,'YTick',-3:1:3)
set(gca,'YTickLabel',{'3','2','1','0','-1','-2','-3'})

axis square
grid on
axis([-3 3 -3 3])
 xlabel('z(Y|n)')
 ylabel('z(Y|s+n)')

title('Double Probability Plot')


   function mouseDown(hObject, eventdata,handles)
        %handles = guidata(hObject);
        % is the mouse down event within the axes?
        %status = false;
                  handles = guidata(hObject);
                      currentPoint = get((handles.Plot3),'CurrentPoint');

               handles.mouseIsDown     = true;
               guidata(hObject,handles);

            
            
   function  mouseUp(hObject, eventdata,handles)
                handles = guidata(hObject);
  if isfield(handles,'mouseIsDown')
        if handles.mouseIsDown
            
            handles.mouseIsDown     = false;
            handles.movingPlotHndle = [];
            handles.prevPoint       = [];
            
            % save the data
            guidata(handles.Plot3,handles);
        end
    end
    
    function mouseMove(hObject, eventdata, handles)
          handles = guidata(hObject);
          
    if isfield(handles,'mouseIsDown')
       if handles.mouseIsDown
  expt = getexpt(handles);
  if expt.activate_beta1==1 | expt.activate_dA==1
            currentPoint = get((handles.Plot1),'CurrentPoint');
            x            = currentPoint(2,1);
            y            = currentPoint(2,2);
            if (x>=-6 && x<=6) && (y>=0 && y<=0.5)
            
                if expt.activate_beta1==1
                set(handles.zFA1, 'String',num2str(x,'%10.3f'));

                end
                if expt.activate_dA==1 & (x>=-6 && x<=6) && (y>=0 && y<=0.5)
                    if x<=0
                        x=0;
                    end
                set(handles.dA, 'String',num2str(x,'%10.3f'));
                end
                Plot_figure(hObject, eventdata, handles)
            end
  end
  
    if expt.activate_beta2==1 | expt.activate_dB==1
            currentPoint = get((handles.Plot2),'CurrentPoint');
            x            = currentPoint(2,1);
            y            = currentPoint(2,2);
            %set(hLineToDrag, 'XData', [x x]);
            if (x>=-6 && x<=6) && (y>=0 && y<=0.5) %&& mouseDown(hObject, eventdata,handles)
            
                if expt.activate_beta2==1
                set(handles.zFA2, 'String',num2str(x,'%10.3f'));

                end
                if expt.activate_dB==1 & (x>=-6 && x<=6) && (y>=0 && y<=0.5)
                    if x<=0
                        x=0;
                    end
                set(handles.dB, 'String',num2str(x,'%10.3f'));
                end
                Plot_figure(hObject, eventdata, handles)
            end
    end
  
  
   if expt.RocA==1
                              handles = guidata(hObject);
 
                      currentPoint = get((handles.Plot3),'CurrentPoint');
            x            = currentPoint(2,1);
            y            = currentPoint(2,2);
                     
            %exptRoc=mouseDown(hObject, eventdata,handles);
           % x=exptRoc.xROC;
           % y=exptRoc.yROC;
            if (x>=0 && x<=1) && (y>=0 && y<=1)
            set(handles.Prob_AC1, 'String',num2str(y,'%10.3f'));
            set(handles.Prob_FA1, 'String',num2str(x,'%10.3f'));
            Plot_figure(hObject, eventdata, handles)

            end
            end
           
      if expt.RocB==1
                              handles = guidata(hObject);
 
                      currentPoint = get((handles.Plot3),'CurrentPoint');
            x            = currentPoint(2,1);
            y            = currentPoint(2,2);
                     
            %exptRoc=mouseDown(hObject, eventdata,handles);
           % x=exptRoc.xROC;
           % y=exptRoc.yROC;
            if (x>=0 && x<=1) && (y>=0 && y<=1)
            set(handles.Prob_AC2, 'String',num2str(y,'%10.3f'));
            set(handles.Prob_FA2, 'String',num2str(x,'%10.3f'));
            Plot_figure(hObject, eventdata, handles)

            end
            end           
                
       end      
                
    end    
          

 %status = false;
  

  


% --- Outputs from this function are returned to the command line.
function varargout = SDT_SP1_OutputFcn(hObject, eventdata, handles)
% varargout  cell array for returning output args (see VARARGOUT);
% hObject    handle to figure
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Get default command line output from handles structure
varargout{1} = handles.output;

% --- Executes on button press in Play_sound.
function Play_sound_Callback(hObject, eventdata, handles)
% hObject    handle to Play_sound (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)
Plot_figure(hObject, eventdata, handles)



% --------------------------------------------------------------------
function OpenMenuItem_Callback(hObject, eventdata, handles)
% hObject    handle to OpenMenuItem (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)
file = uigetfile('*.fig');
if ~isequal(file, 0)
    open(file);
end


% --- Executes during object creation, after setting all properties.
function Aciertos1_CreateFcn(hObject, eventdata, handles)
% hObject    handle to Aciertos1 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called
function Aciertos1_Callback(hObject, eventdata, handles)
Plot_figure(hObject, eventdata, handles)

function expt = getexpt(handles)
% Reads off key data from GUI
%expt = handles.expt;
A = get(handles.Aciertos1,'string');
expt.Aciertos1 = str2double(A);
A = get(handles.Aciertos2,'string');
expt.Aciertos2 = str2double(A);
A = get(handles.Errores1,'string');
expt.Errores1 = str2double(A);
A = get(handles.Errores2,'string');
expt.Errores2 = str2double(A);
A = get(handles.Falsas_alarmas1,'string');
expt.Falsas_alarmas1 = str2double(A);
A = get(handles.Falsas_alarmas2,'string');
expt.Falsas_alarmas2 = str2double(A);
A = get(handles.Rechazos_correctos1,'string');
expt.Rechazos_correctos1 = str2double(A);
A = get(handles.Rechazos_correctos2,'string');
expt.Rechazos_correctos2 = str2double(A);

A = get(handles.Prob_AC1,'string');
expt.Prob_AC1 = str2double(A);
A = get(handles.Prob_AC2,'string');
expt.Prob_AC2 = str2double(A);
A = get(handles.Prob_ER1,'string');
expt.Prob_ER1 = str2double(A);
A = get(handles.Prob_ER2,'string');
expt.Prob_ER2 = str2double(A);
A = get(handles.Prob_FA1,'string');
expt.Prob_FA1 = str2double(A);
A = get(handles.Prob_FA2,'string');
expt.Prob_FA2 = str2double(A);
A = get(handles.Prob_RC1,'string');
expt.Prob_RC1 = str2double(A);
A = get(handles.Prob_RC2,'string');
expt.Prob_RC2 = str2double(A);

A = get(handles.CA,'string');
expt.CA = str2double(A);
A = get(handles.CB,'string');
expt.CB = str2double(A);


A = get(handles.TotalsnA,'string');
expt.TotalsnA = str2double(A);
A = get(handles.TotalnA,'string');
expt.TotalnA = str2double(A);
A = get(handles.TotalsnB,'string');
expt.TotalsnB = str2double(A);
A = get(handles.TotalnB,'string');
expt.TotalnB = str2double(A);

A = get(handles.sigmaS1,'string');
expt.sigmaS1= str2double(A);
A = get(handles.sigmaS2,'string');
expt.sigmaS2= str2double(A);
A = get(handles.sigmaN1,'string');
expt.sigmaN1= str2double(A);
A = get(handles.sigmaN2,'string');
expt.sigmaN2= str2double(A);

A = get(handles.zFA1,'string');
expt.zFA1= str2double(A);
A = get(handles.dA,'string');
expt.dA= str2double(A);
A = get(handles.betaA,'string');
expt.betaA= str2double(A);

A = get(handles.zFA2,'string');
expt.zFA2= str2double(A);
A = get(handles.dB,'string');
expt.dB= str2double(A);
A = get(handles.betaB,'string');
expt.betaB= str2double(A);

expt.Results1  = get(handles.Results1,'value');
expt.Results2  = get(handles.Results2,'value');
expt.Probabilidades1  = get(handles.Probabilidades1,'value');
expt.Probabilidades2  = get(handles.Probabilidades2,'value');

expt.Subject1=get(handles.Subject1,'value');
expt.Subject2=get(handles.Subject2,'value');

expt.isobiasbeta1=get(handles.isobiasbeta1,'value');
expt.isobiasbeta2=get(handles.isobiasbeta2,'value');
expt.isobiasC1=get(handles.isobiasC1,'value');
expt.isobiasC2=get(handles.isobiasC2,'value');
expt.activate_beta1=get(handles.activate_beta1,'value');
expt.activate_dA=get(handles.activate_dA,'value');
expt.activate_beta2=get(handles.activate_beta2,'value');
expt.activate_dB=get(handles.activate_dB,'value');


expt.resultados_botonA=get(handles.resultados_botonA,'Value');
expt.resultados_botonB=get(handles.resultados_botonB,'Value');
expt.RocA=get(handles.RocA,'Value');
expt.RocB=get(handles.RocB,'Value');

% --- Executes on button press in Plot_figure.
function Plot_figure_Callback(hObject, eventdata, handles)
% hObject    handle to Plot_figure (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

Plot_figure(hObject, eventdata, handles)




function CloseMenuItem_Callback(hObject, eventdata, handles)
% hObject    handle to CloseMenuItem (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)
selection = questdlg(['Close ' get(handles.axixX,'Name') '?'],...
                     ['Close ' get(handles.axixX,'Name') '...'],...
                     'Yes','No','Yes');
if strcmp(selection,'No')
    return;
end

delete(handles.axixX)
% --------------------------------------------------------------------
function PrintMenuItem_Callback(hObject, eventdata, handles)
% hObject    handle to PrintMenuItem (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)
printdlg(handles.axixX)

% --------------------------------------------------------------------
function FileMenu_Callback(hObject, eventdata, handles)
% hObject    handle to FileMenu (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)


% --- Executes on button press in Reset.
function Reset_Callback(hObject, eventdata, handles)
% hObject    handle to Reset (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)
set(handles.Aciertos1, 'String', 31);
set(handles.Falsas_alarmas1, 'String', 12);
set(handles.Errores1, 'String', 19);
set(handles.Rechazos_correctos1, 'String', 38);

set(handles.Aciertos2, 'String', 47);
set(handles.Falsas_alarmas2, 'String', 35);
set(handles.Errores2, 'String', 3);
set(handles.Rechazos_correctos2, 'String', 15);

set(handles.Results1,'Value',1)
set(handles.Probabilidades1,'Value',0)

set(handles.Results2,'Value',1)
set(handles.Probabilidades2,'Value',0)

set(handles.Aciertos1,'BackgroundColor',[0.729 0.831 0.957])
set(handles.Errores1,'BackgroundColor',[0.729 0.831 0.957])
set(handles.Falsas_alarmas1,'BackgroundColor',[0.729 0.831 0.957])
set(handles.Rechazos_correctos1,'BackgroundColor',[0.729 0.831 0.957])
set(handles.Prob_AC1,'BackgroundColor','White')
set(handles.Prob_ER1,'BackgroundColor','White')
set(handles.Prob_FA1,'BackgroundColor','White')
set(handles.Prob_RC1,'BackgroundColor','White')

set(handles.TotalsnA,'BackgroundColor','White')
set(handles.TotalnA,'BackgroundColor','White')

set(handles.Aciertos2,'BackgroundColor',[0.925 0.839 0.839])
set(handles.Errores2,'BackgroundColor',[0.925 0.839 0.839])
set(handles.Falsas_alarmas2,'BackgroundColor',[0.925 0.839 0.839])
set(handles.Rechazos_correctos2,'BackgroundColor',[0.925 0.839 0.839])
set(handles.Prob_AC2,'BackgroundColor','White')
set(handles.Prob_ER2,'BackgroundColor','White')
set(handles.Prob_FA2,'BackgroundColor','White')
set(handles.Prob_RC2,'BackgroundColor','White')

set(handles.TotalsnB,'BackgroundColor','White')
set(handles.TotalnB,'BackgroundColor','White')

set(handles.Subject1,'value',1);
set(handles.Subject2,'value',1);
set(handles.isobiasbeta1,'value',0);
set(handles.isobiasbeta2,'value',0);
set(handles.isobiasC1,'value',0);
set(handles.isobiasC2,'value',0);

set(handles.sigmaS1, 'String', 1);
set(handles.sigmaN1, 'String', 1);
set(handles.sigmaS2, 'String', 1);
set(handles.sigmaN2, 'String', 1);

set(handles.activate_beta1,'Value',0)
set(handles.activate_dA,'Value',0)
set(handles.activate_beta2,'Value',0)
set(handles.activate_dB,'Value',0)

set(handles.resultados_botonA,'Value',1)
set(handles.resultados_botonB,'Value',1)

set(handles.RocA,'Value',0)
set(handles.RocB,'Value',0)

Plot_figure(hObject, eventdata, handles)






% --- Executes on slider movement.
function axisX_Callback(hObject, eventdata, handles)
% hObject    handle to axisX (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)
%get(hObject,'Value')
% Hints: get(hObject,'Value') returns position of slider
%        get(hObject,'Min') and get(hObject,'Max') to determine range of slider

Plot_figure(hObject, eventdata, handles)


% --- Executes during object creation, after setting all properties.
function axisX_CreateFcn(hObject, eventdata, handles)
% hObject    handle to axisX (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: slider controls usually have a light gray background.
if isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor',[.9 .9 .9]);
end





function Falsas_alarmas1_Callback(hObject, eventdata, handles)
% hObject    handle to Falsas_alarmas1 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of Falsas_alarmas1 as text
%        str2double(get(hObject,'String')) returns contents of Falsas_alarmas1 as a double
Plot_figure(hObject, eventdata, handles)


% --- Executes during object creation, after setting all properties.
function Falsas_alarmas1_CreateFcn(hObject, eventdata, handles)
% hObject    handle to Falsas_alarmas1 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end



function Errores1_Callback(hObject, eventdata, handles)
% hObject    handle to Errores1 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of Errores1 as text
%        str2double(get(hObject,'String')) returns contents of Errores1 as a double
Plot_figure(hObject, eventdata, handles)


% --- Executes during object creation, after setting all properties.
function Errores1_CreateFcn(hObject, eventdata, handles)
% hObject    handle to Errores1 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end



function Rechazos_correctos1_Callback(hObject, eventdata, handles)
% hObject    handle to Rechazos_correctos1 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of Rechazos_correctos1 as text
%        str2double(get(hObject,'String')) returns contents of Rechazos_correctos1 as a double
Plot_figure(hObject, eventdata, handles)


% --- Executes during object creation, after setting all properties.
function Rechazos_correctos1_CreateFcn(hObject, eventdata, handles)
% hObject    handle to Rechazos_correctos1 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end


% --- Executes on button press in Subject1.
function Subject1_Callback(hObject, eventdata, handles)
% hObject    handle to Subject1 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hint: get(hObject,'Value') returns toggle state of Subject1
Plot_figure(hObject, eventdata, handles)



function Aciertos2_Callback(hObject, eventdata, handles)
% hObject    handle to Aciertos2 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of Aciertos2 as text
%        str2double(get(hObject,'String')) returns contents of Aciertos2 as a double
Plot_figure(hObject, eventdata, handles)


% --- Executes during object creation, after setting all properties.
function Aciertos2_CreateFcn(hObject, eventdata, handles)
% hObject    handle to Aciertos2 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end



function Falsas_alarmas2_Callback(hObject, eventdata, handles)
% hObject    handle to Falsas_alarmas2 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of Falsas_alarmas2 as text
%        str2double(get(hObject,'String')) returns contents of Falsas_alarmas2 as a double
Plot_figure(hObject, eventdata, handles)


% --- Executes during object creation, after setting all properties.
function Falsas_alarmas2_CreateFcn(hObject, eventdata, handles)
% hObject    handle to Falsas_alarmas2 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end



function Errores2_Callback(hObject, eventdata, handles)
% hObject    handle to Errores2 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of Errores2 as text
%        str2double(get(hObject,'String')) returns contents of Errores2 as a double
Plot_figure(hObject, eventdata, handles)


% --- Executes during object creation, after setting all properties.
function Errores2_CreateFcn(hObject, eventdata, handles)
% hObject    handle to Errores2 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end



function Rechazos_correctos2_Callback(hObject, eventdata, handles)
% hObject    handle to Rechazos_correctos2 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of Rechazos_correctos2 as text
%        str2double(get(hObject,'String')) returns contents of Rechazos_correctos2 as a double
Plot_figure(hObject, eventdata, handles)


% --- Executes during object creation, after setting all properties.
function Rechazos_correctos2_CreateFcn(hObject, eventdata, handles)
% hObject    handle to Rechazos_correctos2 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end




function Prob_AC1_Callback(hObject, eventdata, handles)
% hObject    handle to Prob_AC1 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of Prob_AC1 as text
%        str2double(get(hObject,'String')) returns contents of Prob_AC1 as a double
Plot_figure(hObject, eventdata, handles)


% --- Executes during object creation, after setting all properties.
function Prob_AC1_CreateFcn(hObject, eventdata, handles)
% hObject    handle to Prob_AC1 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end



function Prob_FA1_Callback(hObject, eventdata, handles)
% hObject    handle to Prob_FA1 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of Prob_FA1 as text
%        str2double(get(hObject,'String')) returns contents of Prob_FA1 as a double
Plot_figure(hObject, eventdata, handles)


% --- Executes during object creation, after setting all properties.
function Prob_FA1_CreateFcn(hObject, eventdata, handles)
% hObject    handle to Prob_FA1 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end



function Prob_ER1_Callback(hObject, eventdata, handles)
% hObject    handle to Prob_ER1 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of Prob_ER1 as text
%        str2double(get(hObject,'String')) returns contents of Prob_ER1 as a double
Plot_figure(hObject, eventdata, handles)


% --- Executes during object creation, after setting all properties.
function Prob_ER1_CreateFcn(hObject, eventdata, handles)
% hObject    handle to Prob_ER1 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end



function Prob_RC1_Callback(hObject, eventdata, handles)
% hObject    handle to Prob_RC1 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of Prob_RC1 as text
%        str2double(get(hObject,'String')) returns contents of Prob_RC1 as a double
Plot_figure(hObject, eventdata, handles)


% --- Executes during object creation, after setting all properties.
function Prob_RC1_CreateFcn(hObject, eventdata, handles)
% hObject    handle to Prob_RC1 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end



function Prob_AC2_Callback(hObject, eventdata, handles)
% hObject    handle to Prob_AC2 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of Prob_AC2 as text
%        str2double(get(hObject,'String')) returns contents of Prob_AC2 as a double
Plot_figure(hObject, eventdata, handles)


% --- Executes during object creation, after setting all properties.
function Prob_AC2_CreateFcn(hObject, eventdata, handles)
% hObject    handle to Prob_AC2 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end



function Prob_FA2_Callback(hObject, eventdata, handles)
% hObject    handle to Prob_FA2 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of Prob_FA2 as text
%        str2double(get(hObject,'String')) returns contents of Prob_FA2 as a double
Plot_figure(hObject, eventdata, handles)


% --- Executes during object creation, after setting all properties.
function Prob_FA2_CreateFcn(hObject, eventdata, handles)
% hObject    handle to Prob_FA2 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end



function Prob_ER2_Callback(hObject, eventdata, handles)
% hObject    handle to Prob_ER2 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of Prob_ER2 as text
%        str2double(get(hObject,'String')) returns contents of Prob_ER2 as a double
Plot_figure(hObject, eventdata, handles)


% --- Executes during object creation, after setting all properties.
function Prob_ER2_CreateFcn(hObject, eventdata, handles)
% hObject    handle to Prob_ER2 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end



function Prob_RC2_Callback(hObject, eventdata, handles)
% hObject    handle to Prob_RC2 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of Prob_RC2 as text
%        str2double(get(hObject,'String')) returns contents of Prob_RC2 as a double
Plot_figure(hObject, eventdata, handles)


% --- Executes during object creation, after setting all properties.
function Prob_RC2_CreateFcn(hObject, eventdata, handles)
% hObject    handle to Prob_RC2 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end


% --- Executes on button press in checkbox1.
function checkbox1_Callback(hObject, eventdata, handles)
% hObject    handle to checkbox1 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hint: get(hObject,'Value') returns toggle state of checkbox1


% --- Executes on button press in checkbox2.
function checkbox2_Callback(hObject, eventdata, handles)
% hObject    handle to checkbox2 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hint: get(hObject,'Value') returns toggle state of checkbox2



function betaA_Callback(hObject, eventdata, handles)
% hObject    handle to betaA (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of betaA as text
%        str2double(get(hObject,'String')) returns contents of betaA as a double


% --- Executes during object creation, after setting all properties.
function betaA_CreateFcn(hObject, eventdata, handles)
% hObject    handle to betaA (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end



function dA_Callback(hObject, eventdata, handles)
% hObject    handle to dA (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of dA as text
%        str2double(get(hObject,'String')) returns contents of dA as a double


% --- Executes during object creation, after setting all properties.
function dA_CreateFcn(hObject, eventdata, handles)
% hObject    handle to dA (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end



function CA_Callback(hObject, eventdata, handles)
% hObject    handle to CA (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of CA as text
%        str2double(get(hObject,'String')) returns contents of CA as a double


% --- Executes during object creation, after setting all properties.
function CA_CreateFcn(hObject, eventdata, handles)
% hObject    handle to CA (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end



function betaB_Callback(hObject, eventdata, handles)
% hObject    handle to betaB (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of betaB as text
%        str2double(get(hObject,'String')) returns contents of betaB as a double


% --- Executes during object creation, after setting all properties.
function betaB_CreateFcn(hObject, eventdata, handles)
% hObject    handle to betaB (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end



function dB_Callback(hObject, eventdata, handles)
% hObject    handle to dB (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of dB as text
%        str2double(get(hObject,'String')) returns contents of dB as a double


% --- Executes during object creation, after setting all properties.
function dB_CreateFcn(hObject, eventdata, handles)
% hObject    handle to dB (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end



function CB_Callback(hObject, eventdata, handles)
% hObject    handle to CB (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of CB as text
%        str2double(get(hObject,'String')) returns contents of CB as a double


% --- Executes during object creation, after setting all properties.
function CB_CreateFcn(hObject, eventdata, handles)
% hObject    handle to CB (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end



function TotalsnA_Callback(hObject, eventdata, handles)
% hObject    handle to TotalsnA (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of TotalsnA as text
%        str2double(get(hObject,'String')) returns contents of TotalsnA as a double
Plot_figure(hObject, eventdata, handles)


% --- Executes during object creation, after setting all properties.
function TotalsnA_CreateFcn(hObject, eventdata, handles)
% hObject    handle to TotalsnA (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end



function TotalnA_Callback(hObject, eventdata, handles)
% hObject    handle to TotalnA (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of TotalnA as text
%        str2double(get(hObject,'String')) returns contents of TotalnA as a double
Plot_figure(hObject, eventdata, handles)


% --- Executes during object creation, after setting all properties.
function TotalnA_CreateFcn(hObject, eventdata, handles)
% hObject    handle to TotalnA (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end



function TotalA_Callback(hObject, eventdata, handles)
% hObject    handle to TotalA (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of TotalA as text
%        str2double(get(hObject,'String')) returns contents of TotalA as a double


% --- Executes during object creation, after setting all properties.
function TotalA_CreateFcn(hObject, eventdata, handles)
% hObject    handle to TotalA (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end



function TotalsnB_Callback(hObject, eventdata, handles)
% hObject    handle to TotalsnB (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of TotalsnB as text
%        str2double(get(hObject,'String')) returns contents of TotalsnB as a double
Plot_figure(hObject, eventdata, handles)


% --- Executes during object creation, after setting all properties.
function TotalsnB_CreateFcn(hObject, eventdata, handles)
% hObject    handle to TotalsnB (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end



function TotalnB_Callback(hObject, eventdata, handles)
% hObject    handle to TotalnB (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of TotalnB as text
%        str2double(get(hObject,'String')) returns contents of TotalnB as a double
Plot_figure(hObject, eventdata, handles)


% --- Executes during object creation, after setting all properties.
function TotalnB_CreateFcn(hObject, eventdata, handles)
% hObject    handle to TotalnB (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end



function TotalB_Callback(hObject, eventdata, handles)
% hObject    handle to TotalB (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of TotalB as text
%        str2double(get(hObject,'String')) returns contents of TotalB as a double


% --- Executes during object creation, after setting all properties.
function TotalB_CreateFcn(hObject, eventdata, handles)
% hObject    handle to TotalB (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end



function probabilidadesFA1_Callback(hObject, eventdata, handles)
% hObject    handle to probabilidadesFA1 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of probabilidadesFA1 as text
%        str2double(get(hObject,'String')) returns contents of probabilidadesFA1 as a double


% --- Executes during object creation, after setting all properties.
function probabilidadesFA1_CreateFcn(hObject, eventdata, handles)
% hObject    handle to probabilidadesFA1 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end



function zAC1_Callback(hObject, eventdata, handles)
% hObject    handle to zAC1 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of zAC1 as text
%        str2double(get(hObject,'String')) returns contents of zAC1 as a double


% --- Executes during object creation, after setting all properties.
function zAC1_CreateFcn(hObject, eventdata, handles)
% hObject    handle to zAC1 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end



function zFA1_Callback(hObject, eventdata, handles)
% hObject    handle to zFA1 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of zFA1 as text
%        str2double(get(hObject,'String')) returns contents of zFA1 as a double


% --- Executes during object creation, after setting all properties.
function zFA1_CreateFcn(hObject, eventdata, handles)
% hObject    handle to zFA1 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end



function probabilidadesAC1_Callback(hObject, eventdata, handles)
% hObject    handle to probabilidadesAC1 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of probabilidadesAC1 as text
%        str2double(get(hObject,'String')) returns contents of probabilidadesAC1 as a double


% --- Executes during object creation, after setting all properties.
function probabilidadesAC1_CreateFcn(hObject, eventdata, handles)
% hObject    handle to probabilidadesAC1 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end



function probabilidadesFA2_Callback(hObject, eventdata, handles)
% hObject    handle to probabilidadesFA2 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of probabilidadesFA2 as text
%        str2double(get(hObject,'String')) returns contents of probabilidadesFA2 as a double


% --- Executes during object creation, after setting all properties.
function probabilidadesFA2_CreateFcn(hObject, eventdata, handles)
% hObject    handle to probabilidadesFA2 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end



function zAC2_Callback(hObject, eventdata, handles)
% hObject    handle to zAC2 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of zAC2 as text
%        str2double(get(hObject,'String')) returns contents of zAC2 as a double


% --- Executes during object creation, after setting all properties.
function zAC2_CreateFcn(hObject, eventdata, handles)
% hObject    handle to zAC2 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end



function zFA2_Callback(hObject, eventdata, handles)
% hObject    handle to zFA2 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of zFA2 as text
%        str2double(get(hObject,'String')) returns contents of zFA2 as a double


% --- Executes during object creation, after setting all properties.
function zFA2_CreateFcn(hObject, eventdata, handles)
% hObject    handle to zFA2 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end



function probabilidadesAC2_Callback(hObject, eventdata, handles)
% hObject    handle to probabilidadesAC2 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of probabilidadesAC2 as text
%        str2double(get(hObject,'String')) returns contents of probabilidadesAC2 as a double


% --- Executes during object creation, after setting all properties.
function probabilidadesAC2_CreateFcn(hObject, eventdata, handles)
% hObject    handle to probabilidadesAC2 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end


% --- Executes on button press in Results1.
function Results1_Callback(hObject, eventdata, handles)
% hObject    handle to Results1 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hint: get(hObject,'Value') returns toggle state of Results1
set(handles.Probabilidades1,'Value',0)
set(handles.activate_beta1,'Value',0)
set(handles.activate_dA,'Value',0)
set(handles.RocA,'Value',0)

set(handles.Aciertos1,'BackgroundColor',[0.729 0.831 0.957])
set(handles.Errores1,'BackgroundColor',[0.729 0.831 0.957])
set(handles.Falsas_alarmas1,'BackgroundColor',[0.729 0.831 0.957])
set(handles.Rechazos_correctos1,'BackgroundColor',[0.729 0.831 0.957])
%set(handles.Rechazos_correctos1,'Visible','off')
set(handles.Prob_AC1,'BackgroundColor','White')
set(handles.Prob_ER1,'BackgroundColor','White')
set(handles.Prob_FA1,'BackgroundColor','White')
set(handles.Prob_RC1,'BackgroundColor','White')

set(handles.TotalsnA,'BackgroundColor','White')
set(handles.TotalnA,'BackgroundColor','White')

set(handles.Results1,'Value',1)
Plot_figure(hObject, eventdata, handles)


% --- Executes on button press in Results2.
function Results2_Callback(hObject, eventdata, handles)
% hObject    handle to Results2 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)
set(handles.Probabilidades2,'Value',0)
set(handles.activate_beta2,'Value',0)
set(handles.activate_dB,'Value',0)
set(handles.RocB,'Value',0)

% Hint: get(hObject,'Value') returns toggle state of Results2
set(handles.Aciertos2,'BackgroundColor',[0.925 0.839 0.839])
set(handles.Errores2,'BackgroundColor',[0.925 0.839 0.839])
set(handles.Falsas_alarmas2,'BackgroundColor',[0.925 0.839 0.839])
set(handles.Rechazos_correctos2,'BackgroundColor',[0.925 0.839 0.839])
%set(handles.Rechazos_correctos1,'Visible','off')
set(handles.Prob_AC2,'BackgroundColor','White')
set(handles.Prob_ER2,'BackgroundColor','White')
set(handles.Prob_FA2,'BackgroundColor','White')
set(handles.Prob_RC2,'BackgroundColor','White')

set(handles.TotalsnB,'BackgroundColor','White')
set(handles.TotalnB,'BackgroundColor','White')

set(handles.Results2,'Value',1)
Plot_figure(hObject, eventdata, handles)


% --- Executes on button press in Probabilidades1.
function Probabilidades1_Callback(hObject, eventdata, handles)
% hObject    handle to Probabilidades1 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hint: get(hObject,'Value') returns toggle state of Probabilidades1
set(handles.Results1,'Value',0)
set(handles.Probabilidades1,'Value',1)
set(handles.activate_beta1,'Value',0)
set(handles.activate_dA,'Value',0)
set(handles.RocA,'Value',0)

set(handles.Aciertos1,'BackgroundColor','White')
set(handles.Errores1,'BackgroundColor','White')
set(handles.Falsas_alarmas1,'BackgroundColor','White')
set(handles.Rechazos_correctos1,'BackgroundColor','White')
set(handles.Prob_AC1,'BackgroundColor',[0.729 0.831 0.957])
set(handles.Prob_FA1,'BackgroundColor',[0.729 0.831 0.957])

set(handles.TotalsnA,'BackgroundColor',[0.729 0.831 0.957])
set(handles.TotalnA,'BackgroundColor',[0.729 0.831 0.957])
Plot_figure(hObject, eventdata, handles)

% --- Executes on button press in Probabilidades2.
function Probabilidades2_Callback(hObject, eventdata, handles)
% hObject    handle to Probabilidades2 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hint: get(hObject,'Value') returns toggle state of Probabilidades2
set(handles.Results2,'Value',0)
set(handles.Probabilidades2,'Value',1)
set(handles.activate_beta2,'Value',0)
set(handles.activate_dB,'Value',0)
set(handles.RocB,'Value',0)

set(handles.Aciertos2,'BackgroundColor','White')
set(handles.Errores2,'BackgroundColor','White')
set(handles.Falsas_alarmas2,'BackgroundColor','White')
set(handles.Rechazos_correctos2,'BackgroundColor','White')
set(handles.Prob_AC2,'BackgroundColor',[0.925 0.839 0.839])
set(handles.Prob_FA2,'BackgroundColor',[0.925 0.839 0.839])

set(handles.TotalsnB,'BackgroundColor',[0.925 0.839 0.839])
set(handles.TotalnB,'BackgroundColor',[0.925 0.839 0.839])
Plot_figure(hObject, eventdata, handles)


% --- Executes on button press in Subject2.
function Subject2_Callback(hObject, eventdata, handles)
% hObject    handle to Subject2 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hint: get(hObject,'Value') returns toggle state of Subject2
Plot_figure(hObject, eventdata, handles)


% --- Executes on button press in isobiasbeta1.
function isobiasbeta1_Callback(hObject, eventdata, handles)
% hObject    handle to isobiasbeta1 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hint: get(hObject,'Value') returns toggle state of isobiasbeta1
Plot_figure(hObject, eventdata, handles)

% --- Executes on button press in isobiasbeta2.
function isobiasbeta2_Callback(hObject, eventdata, handles)
% hObject    handle to isobiasbeta2 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hint: get(hObject,'Value') returns toggle state of isobiasbeta2
Plot_figure(hObject, eventdata, handles)

% --- Executes on button press in isobiasC1.
function isobiasC1_Callback(hObject, eventdata, handles)
% hObject    handle to isobiasC1 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hint: get(hObject,'Value') returns toggle state of isobiasC1
Plot_figure(hObject, eventdata, handles)

% --- Executes on button press in isobiasC2.
function isobiasC2_Callback(hObject, eventdata, handles)
% hObject    handle to isobiasC2 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hint: get(hObject,'Value') returns toggle state of isobiasC2
Plot_figure(hObject, eventdata, handles)



function sigmaN1_Callback(hObject, eventdata, handles)
% hObject    handle to sigmaN1 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of sigmaN1 as text
%        str2double(get(hObject,'String')) returns contents of sigmaN1 as a double
Plot_figure(hObject, eventdata, handles)


% --- Executes during object creation, after setting all properties.
function sigmaN1_CreateFcn(hObject, eventdata, handles)
% hObject    handle to sigmaN1 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end



function sigmaS1_Callback(hObject, eventdata, handles)
% hObject    handle to sigmaS1 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of sigmaS1 as text
%        str2double(get(hObject,'String')) returns contents of sigmaS1 as a double
Plot_figure(hObject, eventdata, handles)


% --- Executes during object creation, after setting all properties.
function sigmaS1_CreateFcn(hObject, eventdata, handles)
% hObject    handle to sigmaS1 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end



function sigmaN2_Callback(hObject, eventdata, handles)
% hObject    handle to sigmaN2 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of sigmaN2 as text
%        str2double(get(hObject,'String')) returns contents of sigmaN2 as a double
Plot_figure(hObject, eventdata, handles)


% --- Executes during object creation, after setting all properties.
function sigmaN2_CreateFcn(hObject, eventdata, handles)
% hObject    handle to sigmaN2 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end



function sigmaS2_Callback(hObject, eventdata, handles)
% hObject    handle to sigmaS2 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of sigmaS2 as text
%        str2double(get(hObject,'String')) returns contents of sigmaS2 as a double
Plot_figure(hObject, eventdata, handles)


% --- Executes during object creation, after setting all properties.
function sigmaS2_CreateFcn(hObject, eventdata, handles)
% hObject    handle to sigmaS2 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end


% --- Executes on button press in activate_beta1.
function activate_beta1_Callback(hObject, eventdata, handles)
% hObject    handle to activate_beta1 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hint: get(hObject,'Value') returns toggle state of activate_beta1
set(handles.Aciertos1,'BackgroundColor','White')
set(handles.Errores1,'BackgroundColor','White')
set(handles.Falsas_alarmas1,'BackgroundColor','White')
set(handles.Rechazos_correctos1,'BackgroundColor','White')
set(handles.Prob_AC1,'BackgroundColor','White')
set(handles.Prob_FA1,'BackgroundColor','White')

set(handles.TotalsnA,'BackgroundColor','White')
set(handles.TotalnA,'BackgroundColor','White')

set(handles.Results1,'Value',0)
set(handles.Probabilidades1,'Value',0)
set(handles.RocA,'Value',0)

Plot_figure(hObject, eventdata, handles)



% --- Executes on button press in activate_dA.
function activate_dA_Callback(hObject, eventdata, handles)
% hObject    handle to activate_dA (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hint: get(hObject,'Value') returns toggle state of activate_dA
set(handles.Aciertos1,'BackgroundColor','White')
set(handles.Errores1,'BackgroundColor','White')
set(handles.Falsas_alarmas1,'BackgroundColor','White')
set(handles.Rechazos_correctos1,'BackgroundColor','White')
set(handles.Prob_AC1,'BackgroundColor','White')
set(handles.Prob_FA1,'BackgroundColor','White')

set(handles.TotalsnA,'BackgroundColor','White')
set(handles.TotalnA,'BackgroundColor','White')

set(handles.Results1,'Value',0)
set(handles.Probabilidades1,'Value',0)
set(handles.RocA,'Value',0)

Plot_figure(hObject, eventdata, handles)


% --- Executes on button press in resultados_botonA.
function resultados_botonA_Callback(hObject, eventdata, handles)
% hObject    handle to resultados_botonA (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hint: get(hObject,'Value') returns toggle state of resultados_botonA

Plot_figure(hObject, eventdata, handles)

% --- Executes on button press in resultados_botonB.
function resultados_botonB_Callback(hObject, eventdata, handles)
% hObject    handle to resultados_botonB (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hint: get(hObject,'Value') returns toggle state of resultados_botonB

Plot_figure(hObject, eventdata, handles)


% --- Executes on button press in RocA.
function RocA_Callback(hObject, eventdata, handles)
% hObject    handle to RocA (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hint: get(hObject,'Value') returns toggle state of RocA
set(handles.Aciertos1,'BackgroundColor','White')
set(handles.Errores1,'BackgroundColor','White')
set(handles.Falsas_alarmas1,'BackgroundColor','White')
set(handles.Rechazos_correctos1,'BackgroundColor','White')
set(handles.Prob_AC1,'BackgroundColor','White')
set(handles.Prob_FA1,'BackgroundColor','White')

set(handles.TotalsnA,'BackgroundColor','White')
set(handles.TotalnA,'BackgroundColor','White')

set(handles.Results1,'Value',0)
set(handles.Probabilidades1,'Value',0)

set(handles.activate_dA,'Value',0)
set(handles.activate_beta1,'Value',0)

Plot_figure(hObject, eventdata, handles)


% --- Executes on button press in activate_dB.
function activate_dB_Callback(hObject, eventdata, handles)
% hObject    handle to activate_dB (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hint: get(hObject,'Value') returns toggle state of activate_dB
set(handles.Aciertos2,'BackgroundColor','White')
set(handles.Errores2,'BackgroundColor','White')
set(handles.Falsas_alarmas2,'BackgroundColor','White')
set(handles.Rechazos_correctos2,'BackgroundColor','White')
set(handles.Prob_AC2,'BackgroundColor','White')
set(handles.Prob_FA2,'BackgroundColor','White')

set(handles.TotalsnB,'BackgroundColor','White')
set(handles.TotalnB,'BackgroundColor','White')

set(handles.Results2,'Value',0)
set(handles.Probabilidades2,'Value',0)
set(handles.RocB,'Value',0)

Plot_figure(hObject, eventdata, handles)

% --- Executes on button press in activate_beta2.
function activate_beta2_Callback(hObject, eventdata, handles)
% hObject    handle to activate_beta2 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hint: get(hObject,'Value') returns toggle state of activate_beta2
set(handles.Aciertos2,'BackgroundColor','White')
set(handles.Errores2,'BackgroundColor','White')
set(handles.Falsas_alarmas2,'BackgroundColor','White')
set(handles.Rechazos_correctos2,'BackgroundColor','White')
set(handles.Prob_AC2,'BackgroundColor','White')
set(handles.Prob_FA2,'BackgroundColor','White')

set(handles.TotalsnB,'BackgroundColor','White')
set(handles.TotalnB,'BackgroundColor','White')

set(handles.Results2,'Value',0)
set(handles.Probabilidades2,'Value',0)
set(handles.RocB,'Value',0)

Plot_figure(hObject, eventdata, handles)

% --- Executes on button press in RocB.
function RocB_Callback(hObject, eventdata, handles)
% hObject    handle to RocB (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hint: get(hObject,'Value') returns toggle state of RocB
set(handles.Aciertos2,'BackgroundColor','White')
set(handles.Errores2,'BackgroundColor','White')
set(handles.Falsas_alarmas2,'BackgroundColor','White')
set(handles.Rechazos_correctos2,'BackgroundColor','White')
set(handles.Prob_AC2,'BackgroundColor','White')
set(handles.Prob_FA2,'BackgroundColor','White')

set(handles.TotalsnB,'BackgroundColor','White')
set(handles.TotalnB,'BackgroundColor','White')

set(handles.Results2,'Value',0)
set(handles.Probabilidades2,'Value',0)

set(handles.activate_dB,'Value',0)
set(handles.activate_beta2,'Value',0)

Plot_figure(hObject, eventdata, handles)


% --- Executes on button press in plot.
function plot_Callback(hObject, eventdata, handles)
% hObject    handle to plot (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)
Plot_figure(hObject, eventdata, handles)