\NeedsTeXFormat{LaTeX2e}
\ProvidesPackage{flyx}[2019/10/16]
\LoadClass[notumble, 12pt, a4paper]{leaflet}
\usepackage[spanish]{babel}
\usepackage[utf8]{inputenc}
\usepackage{color}
\usepackage{flowfram}
\usepackage{graphicx}
\usepackage{multirow}
\usepackage{array}
\usepackage{multirow}
\usepackage{titlesec}
\usepackage[usenames,dvipsnames]{xcolor}
\usepackage{setspace} 
\definecolor{verdechachi}{cmyk}{0.35,0,0.67,0.41}
\definecolor{amethyst}{RGB}{217, 0, 255}
\definecolor{garnett}{RGB}{254, 0, 150}
\definecolor{perfectgray}{RGB}{36, 30, 32}
\usepackage{wrapfig}
\usepackage{lipsum}
\usepackage{hyperref}
\usepackage{rotating}
\makeatletter
\newcommand{\globalcolor}[1]{
  \color{#1}\global\let\default@color\current@color
}
\makeatother
\AtBeginDocument{\globalcolor{white}}
\AddToBackground{6}{
  \put(0,0){\textcolor{perfectgray}{\rule{\paperwidth}{\paperheight}}}}
  \AtBeginDocument{\globalcolor{white}}
\AddToBackground{5}{
  \put(0,0){\textcolor{perfectgray}{\rule{\paperwidth}{\paperheight}}}}
  \AddToBackground{4}{
  \put(0,0){\textcolor{perfectgray}{\rule{\paperwidth}{\paperheight}}}}
  \AddToBackground{3}{
  \put(0,0){\textcolor{perfectgray}{\rule{\paperwidth}{\paperheight}}}}
  \AddToBackground{2}{
  \put(0,0){\textcolor{perfectgray}{\rule{\paperwidth}{\paperheight}}}}
  \AddToBackground{1}{
  \put(0,0){\textcolor{perfectgray}{\rule{\paperwidth}{\paperheight}}}}
\onehalfspacing
\usepackage[inline]{enumitem}
\titleformat*{\subsection}{\color{amethyst}}
\titleformat*{\section}{\color{garnett}}
\renewcommand{\familydefault}{cmss} 
\vtwotonetop{1cm}{0.6\paperwidth}{garnett}{topleft}%
{0.4\paperwidth}{garnett}{topright}
\vtwotonebottom{1cm}{0.6\paperwidth}{garnett}{bottomleft}%
{0.4\paperwidth}{garnett}{bottomright}
\newcommand*{\titulo}[3]{
    \begin{center}
	{\Large #1} \\[.3cm]
	\textit{---}\\[.4cm]
	{\huge {#2}}\\ [.3cm]
	\textbf{{\large #3}}\\[.5cm]
	\includegraphics[scale=0.4]{logo}\\ \vfill
	\textbf{Más texto}\\
	{\large \textbf{Más texto grande}}\\[.5cm]
	{\large \textbf{Más texto}}\\[.5cm]
	\textit{en}\\
	\large{Facultad de Informática - Universidad Complutense de madrid}
	\vfill
	Coordinador del evento\\ 
	\textbf{Nombre}
\end{center}}

\endinput